# -*- coding: utf-8 -*-
"""
Created on Thu Mar 11 12:45:37 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os
from mpl_toolkits.axes_grid1 import Divider, Size

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

CM_SUBSECTION_ORANGES = np.linspace(0.3, 1.0, 1000) 
COLOURS_ORANGES = [ cm.Oranges(x) for x in CM_SUBSECTION_ORANGES ]

CM_SUBSECTION_BLUES = np.linspace(0.3, 1.0, 1000) 
COLOURS_BLUES = [ cm.Blues(x) for x in CM_SUBSECTION_BLUES ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
data_folder_name = 'data'
data_folder_path = os.path.join(main_folder_path,data_folder_name)
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================

selected_files = ['dyrvik_IGLED19-Batch5_002723_3_8.ilv_processed', \
                 'dyrvik_IGLED19-Batch5_00272C_8_5.ilv_processed']


# best eqe of each type
# =============================================================================
# selected_files = ['dyrvik_IGLED19-Batch5_002723_3_8.ilv_processed', \
#                  'dyrvik_IGLED19-Batch5_002727_5_8.ilv_processed', \
#                  'dyrvik_IGLED19-Batch5_00272C_8_5.ilv_processed', \
#                  'dyrvik_IGLED19-Batch5_00272F_8_9.ilv_processed', \
#                  'dyrvik_IGLED19-batch5_002734_5_14.ilv_processed']
# =============================================================================

#representative scans also used for jvl
# =============================================================================
# selected_files = ['dyrvik_IGLED19-Batch5_002724_3_1.ilv_processed', \
#                  'dyrvik_IGLED19-Batch5_002728_5_1.ilv_processed', \
#                  'dyrvik_IGLED19-Batch5_00272c_6_1.ilv_processed', \
#                  'dyrvik_IGLED19-Batch5_002730_6_1.ilv_processed', \
#                  'dyrvik_IGLED19-Batch5_002734_6_1.ilv_processed']
# =============================================================================

"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8  

"""Prepare plots"""
#colour_array =  np.linspace(0, 999, len(selected_files))
colour_array = [200, 800]

fig = plt.figure(figsize=(7.5, 7.5))
h = [Size.Fixed(1.0), Size.Scaled(1.), Size.Fixed(.2)]
v = [Size.Fixed(0.7), Size.Scaled(1.), Size.Fixed(.5)]
divider = Divider(fig, (0, 0, 1, 1), h, v, aspect=False)
# The width and height of the rectangle are ignored.
ax = plt.axes([0.15, 0.15, 0.85, 0.85])
ax.set_xlabel('Current Density [$\mathregular{mA/cm^2}$]')
ax.set_ylabel('$\mathregular{EQE_{EL}}$ [%]')

label_strings = ['0 cycles',\
                 '10 cycles']
    
"""Plot the data"""
for i in range(len(selected_files)):
    file_path = os.path.join(data_folder_path,selected_files[i])
    df = pd.read_csv(file_path)
    
    ax.semilogx(df['LED current [mA/cm2]'], df['EQE [%]'], color=COLOURS_GREENS[np.int(colour_array[i])], label=label_strings[i])

"""Axis settings"""
ax.set_xlim(left=3e-3)
ax.set_ylim(bottom = 0, top = 15.5)
ax.yaxis.set_major_locator(mpl.ticker.MultipleLocator(2))
ax.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(1))

"""Annotation"""
ax.text(0.05, 0.95, '11 nm TFB',
        horizontalalignment='left',
        verticalalignment='top',
        transform=ax.transAxes)

"""Legend"""
leg = ax.legend(frameon = False)

# Right-aligning the legend
vp = leg._legend_box._children[-1]._children[0]
for c in vp._children:
    c._children.reverse()
vp.align="right"

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw*1.5

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

"""Exporting plots"""
plot_name = 'Plot EQE(J) ALD Cycles'
export_name_pdf = plot_name + '.pdf'
export_name_svg = plot_name + '.svg'
#export_name_eps = plot_name + '.eps'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
#eps_path = os.path.join(export_folder_path,export_name_eps)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path, bbox_inches='tight')
fig.savefig(svg_path, bbox_inches='tight')
#fig.savefig(eps_path, bbox_inches='tight')
plt.close(fig)
